/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0)

/////////////////////////////////////////////////////////////////////////////////

// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// Created by S.Guillitte 

float hash( in vec2 p ) 
{
    return fract(sin(p.x*15.32+p.y*35.78) * 43758.23);
}

vec2 hash2(vec2 p)
{
	return vec2(hash(p*.754),hash(1.5743*p.yx+4.5891))-.5;
}


vec2 add = vec2(1.0, 0.0);

vec2 noise2(vec2 x)
{
    vec2 p = floor(x);
    vec2 f = fract(x);
    f = f*f*(3.0-2.0*f);
    
    return mix(mix( hash2(p),          hash2(p + add.xy),f.x),
                    mix( hash2(p + add.yx), hash2(p + add.xx),f.x),f.y);
    
}


float dseg( vec2 ba, vec2 pa )
{	
	float h = clamp( dot(pa,ba)/dot(ba,ba), 0., 1. );	
	return length( pa - ba*h );
}


vec2 delirium(vec2 x)
{
    vec2 r = x;
    float a = 1.;
    float d=10.;
    for (int i = 0; i < 12; i++)
    {
        vec2 s= noise2(r*a)/a+.2;
        d=min(d,dseg(r-x,s));
        r +=s;      
        //a*=1.9;
    }     
    return normalize(r-x)*d;
}


void main(void)
{
	vec2 uv = 2.*gl_FragCoord.xy / iResolution.yy;
    uv*=5.;
    vec2 p = delirium(uv+1.*iGlobalTime);
    float c = length(p)*20.;
    vec3 col;
    col=vec3(0.6,0.7-5.*p.x,0.8+7.*p.y)*c;
	gl_FragColor = vec4(col,1.0);
}